/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Inventories {
    public static boolean areItemStacksIdentical(class_1799 a, class_1799 b) {
        return a.method_7909() == b.method_7909() && class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    public static boolean areItemStacksDifferent(class_1799 a, class_1799 b) {
        return a.method_7909() != b.method_7909() || !class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    public static boolean areItemStacksIdenticalIgnoreDamage(class_1799 a, class_1799 b) {
        if (a.method_7909() != b.method_7909()) {
            return false;
        }
        if (!a.method_7963()) {
            return class_1799.method_31577((class_1799)a, (class_1799)b);
        }
        class_9323 bc = b.method_57353();
        return a.method_57353().method_57833().allMatch(a_tdc -> {
            if (!bc.method_57832(a_tdc.comp_2443())) {
                return false;
            }
            if (a_tdc.comp_2444().equals(bc.method_57829(a_tdc.comp_2443()))) {
                return true;
            }
            return a_tdc.comp_2443().equals((Object)class_9334.field_49629);
        });
    }

    public static boolean isItemStackableOn(class_1799 a, class_1799 b) {
        return !a.method_7960() && a.method_7946() && class_1799.method_7984((class_1799)a, (class_1799)b);
    }

    public static class_1799 extract(class_1657 player, @Nullable class_1799 match, int amount, boolean simulate) {
        if (amount <= 0) {
            return class_1799.field_8037;
        }
        InventoryRange ir = InventoryRange.fromPlayerInventory(player);
        if (match == null) {
            return ir.extract(amount, false, simulate);
        }
        class_1799 mstack = match.method_7972();
        mstack.method_7939(amount);
        return ir.extract(mstack, simulate);
    }

    public static class_1799 insert(class_1657 player, class_1799 stack, boolean simulate) {
        return InventoryRange.fromPlayerInventory(player).insert(stack, simulate);
    }

    private static class_1799 checked(class_1799 stack) {
        return stack.method_7960() ? class_1799.field_8037 : stack;
    }

    public static class_1263 copyOf(class_1263 src) {
        int size = src.method_5439();
        class_1277 dst = new class_1277(size);
        for (int i = 0; i < size; ++i) {
            dst.method_5447(i, src.method_5438(i).method_7972());
        }
        return dst;
    }

    public static class_1799 insert(InventoryRange[] to_ranges, class_1799 stack) {
        class_1799 remaining = stack.method_7972();
        for (InventoryRange range : to_ranges) {
            if (!(remaining = range.insert(remaining, false, 0, false, true)).method_7960()) continue;
            return remaining;
        }
        return remaining;
    }

    public static void give(class_1657 entity, class_1799 stack) {
        entity.method_31548().method_7398(stack);
    }

    public static class InventoryRange
    implements class_1263,
    Iterable<class_1799> {
        protected final class_1263 inventory_;
        protected final int offset_;
        protected final int size_;
        protected final int num_rows;
        protected int max_stack_size_ = 64;
        protected BiPredicate<Integer, class_1799> validator_ = (index, stack) -> true;

        public static InventoryRange fromPlayerHotbar(class_1657 player) {
            return new InventoryRange((class_1263)player.method_31548(), 0, 9, 1);
        }

        public static InventoryRange fromPlayerStorage(class_1657 player) {
            return new InventoryRange((class_1263)player.method_31548(), 9, 27, 3);
        }

        public static InventoryRange fromPlayerInventory(class_1657 player) {
            return new InventoryRange((class_1263)player.method_31548(), 0, 36, 4);
        }

        public InventoryRange(class_1263 inventory, int offset, int size, int num_rows) {
            this.inventory_ = inventory;
            this.offset_ = class_3532.method_15340((int)offset, (int)0, (int)(inventory.method_5439() - 1));
            this.size_ = class_3532.method_15340((int)size, (int)0, (int)(inventory.method_5439() - this.offset_));
            this.num_rows = num_rows;
        }

        public InventoryRange(class_1263 inventory, int offset, int size) {
            this(inventory, offset, size, 1);
        }

        public InventoryRange(class_1263 inventory) {
            this(inventory, 0, inventory.method_5439(), 1);
        }

        public final class_1263 inventory() {
            return this.inventory_;
        }

        public final int size() {
            return this.size_;
        }

        public final int offset() {
            return this.offset_;
        }

        public final class_1799 get(int index) {
            return this.inventory_.method_5438(this.offset_ + index);
        }

        public final void set(int index, class_1799 stack) {
            this.inventory_.method_5447(this.offset_ + index, stack);
        }

        public final InventoryRange setValidator(BiPredicate<Integer, class_1799> validator) {
            this.validator_ = validator;
            return this;
        }

        public final BiPredicate<Integer, class_1799> getValidator() {
            return this.validator_;
        }

        public final InventoryRange setMaxStackSize(int count) {
            this.max_stack_size_ = Math.max(count, 1);
            return this;
        }

        public void method_5448() {
            for (int i = 0; i < this.size_; ++i) {
                this.method_5447(i, class_1799.field_8037);
            }
        }

        public int method_5439() {
            return this.size_;
        }

        public boolean method_5442() {
            for (int i = 0; i < this.size_; ++i) {
                if (this.inventory_.method_5438(this.offset_ + i).method_7960()) continue;
                return false;
            }
            return true;
        }

        public class_1799 method_5438(int index) {
            return this.inventory_.method_5438(this.offset_ + index);
        }

        public class_1799 method_5434(int index, int count) {
            return this.inventory_.method_5434(this.offset_ + index, count);
        }

        public class_1799 method_5441(int index) {
            return this.inventory_.method_5441(this.offset_ + index);
        }

        public void method_5447(int index, class_1799 stack) {
            this.inventory_.method_5447(this.offset_ + index, stack);
        }

        public int method_5444() {
            return Math.min(this.max_stack_size_, this.inventory_.method_5444());
        }

        public void method_5431() {
            this.inventory_.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return this.inventory_.method_5443(player);
        }

        public void method_5435(class_1657 player) {
            this.inventory_.method_5435(player);
        }

        public void method_5432(class_1657 player) {
            this.inventory_.method_5432(player);
        }

        public boolean method_5437(int index, class_1799 stack) {
            return this.validator_.test(this.offset_ + index, stack) && this.inventory_.method_5437(this.offset_ + index, stack);
        }

        public boolean iterate(BiPredicate<Integer, class_1799> fn) {
            for (int i = 0; i < this.size_; ++i) {
                if (!fn.test(i, this.method_5438(i))) continue;
                return true;
            }
            return false;
        }

        public boolean contains(class_1799 stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.method_5438(i))) continue;
                return true;
            }
            return false;
        }

        public int indexOf(class_1799 stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.method_5438(i))) continue;
                return i;
            }
            return -1;
        }

        public <T> Optional<T> find(BiFunction<Integer, class_1799, Optional<T>> fn) {
            for (int i = 0; i < this.size_; ++i) {
                Optional<T> r = fn.apply(i, this.method_5438(i));
                if (!r.isPresent()) continue;
                return r;
            }
            return Optional.empty();
        }

        public <T> List<T> collect(BiFunction<Integer, class_1799, Optional<T>> fn) {
            ArrayList data = new ArrayList();
            for (int i = 0; i < this.size_; ++i) {
                fn.apply(i, this.method_5438(i)).ifPresent(data::add);
            }
            return data;
        }

        public Stream<class_1799> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<class_1799> iterator() {
            return new InventoryRangeIterator(this);
        }

        public int stackMatchCount(class_1799 ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(ref_stack, this.method_5438(i))) continue;
                ++n;
            }
            return n;
        }

        public int totalMatchingItemCount(class_1799 ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                class_1799 stack = this.method_5438(i);
                if (!Inventories.areItemStacksIdentical(ref_stack, stack)) continue;
                n += stack.method_7947();
            }
            return n;
        }

        public class_1799 insert(class_1799 input_stack, boolean only_fillup, int limit, boolean reverse, boolean force_group_stacks) {
            int nmax;
            class_1799 stack;
            int sno;
            int i;
            class_1799 mvstack = input_stack.method_7972();
            if (mvstack.method_7960()) {
                return Inventories.checked(mvstack);
            }
            int limit_left = limit > 0 ? Math.min(limit, mvstack.method_7914()) : mvstack.method_7914();
            boolean[] matches = new boolean[this.size_];
            boolean[] empties = new boolean[this.size_];
            int num_matches = 0;
            for (i = 0; i < this.size_; ++i) {
                sno = reverse ? this.size_ - 1 - i : i;
                stack = this.method_5438(sno);
                if (stack.method_7960()) {
                    empties[sno] = true;
                    continue;
                }
                if (!Inventories.areItemStacksIdentical(stack, mvstack)) continue;
                matches[sno] = true;
                ++num_matches;
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (empties[sno] || !matches[sno]) continue;
                stack = this.method_5438(sno);
                nmax = Math.min(limit_left, stack.method_7914() - stack.method_7947());
                if (mvstack.method_7947() <= nmax) {
                    stack.method_7939(stack.method_7947() + mvstack.method_7947());
                    this.method_5447(sno, stack);
                    return class_1799.field_8037;
                }
                mvstack.method_7934(nmax);
                limit_left -= nmax;
                stack.method_7933(nmax);
                this.method_5447(sno, stack);
            }
            if (only_fillup) {
                return Inventories.checked(mvstack);
            }
            if (num_matches > 0 && (force_group_stacks || this.inventory_ instanceof class_1661)) {
                int sno2;
                int i2;
                int insert_start = -1;
                int insert_end = -1;
                for (i2 = 1; i2 < this.size_ - 1; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (insert_start < 0) {
                        if (!matches[sno2]) continue;
                        insert_start = sno2;
                        continue;
                    }
                    if (!matches[sno2]) continue;
                    insert_end = sno2;
                }
                for (i2 = insert_start; i2 < insert_end; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (!empties[sno2] || !this.method_5437(sno2, mvstack)) continue;
                    int nmax2 = Math.min(limit_left, mvstack.method_7947());
                    class_1799 moved = mvstack.method_7972();
                    moved.method_7939(nmax2);
                    mvstack.method_7934(nmax2);
                    this.method_5447(sno2, moved);
                    return Inventories.checked(mvstack);
                }
                for (i = 1; i < this.size_ - 1; ++i) {
                    int ii;
                    int n = sno = reverse ? this.size_ - 1 - i : i;
                    if (!matches[sno]) continue;
                    int n2 = empties[sno - 1] ? sno - 1 : (ii = empties[sno + 1] ? sno + 1 : -1);
                    if (ii < 0 || !this.method_5437(ii, mvstack)) continue;
                    nmax = Math.min(limit_left, mvstack.method_7947());
                    class_1799 moved = mvstack.method_7972();
                    moved.method_7939(nmax);
                    mvstack.method_7934(nmax);
                    this.method_5447(ii, moved);
                    return Inventories.checked(mvstack);
                }
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (!empties[sno] || !this.method_5437(sno, mvstack)) continue;
                int nmax3 = Math.min(limit_left, mvstack.method_7947());
                class_1799 placed = mvstack.method_7972();
                placed.method_7939(nmax3);
                mvstack.method_7934(nmax3);
                this.method_5447(sno, placed);
                return Inventories.checked(mvstack);
            }
            return Inventories.checked(mvstack);
        }

        public class_1799 insert(class_1799 input_stack, boolean simulate) {
            if (input_stack.method_7960()) {
                return class_1799.field_8037;
            }
            if (!simulate) {
                return this.insert(input_stack);
            }
            input_stack = input_stack.method_7972();
            for (class_1799 stack : this) {
                if (stack.method_7960()) {
                    return class_1799.field_8037;
                }
                int nleft = stack.method_7947() - stack.method_7914();
                if (nleft <= 0 || !Inventories.isItemStackableOn(stack, input_stack)) continue;
                if (nleft >= input_stack.method_7947()) {
                    return class_1799.field_8037;
                }
                input_stack.method_7934(nleft);
            }
            return input_stack;
        }

        public class_1799 insert(class_1799 stack_to_move) {
            return this.insert(stack_to_move, false, 0, false, true);
        }

        public class_1799 insert(int index, class_1799 stack_to_move) {
            if (stack_to_move.method_7960()) {
                return stack_to_move;
            }
            class_1799 stack = this.method_5438(index);
            int limit = Math.min(this.method_5444(), stack.method_7914());
            if (stack.method_7960()) {
                this.method_5447(index, stack_to_move.method_7972());
                return class_1799.field_8037;
            }
            if (stack.method_7947() >= limit || !Inventories.areItemStacksIdentical(stack, stack_to_move)) {
                return stack_to_move;
            }
            int amount = Math.min(limit - stack.method_7947(), stack_to_move.method_7947());
            class_1799 remaining = stack_to_move.method_7972();
            remaining.method_7934(amount);
            stack.method_7933(amount);
            return remaining.method_7960() ? class_1799.field_8037 : remaining;
        }

        public class_1799 extract(int amount) {
            return this.extract(amount, false);
        }

        public class_1799 extract(int amount, boolean random) {
            return this.extract(amount, false, false);
        }

        public class_1799 extract(int amount, boolean random, boolean simulate) {
            class_1799 out_stack = class_1799.field_8037;
            int offset = random ? (int)(Math.random() * (double)this.size_) : 0;
            for (int k = 0; k < this.size_; ++k) {
                int i = (offset + k) % this.size_;
                class_1799 stack = this.method_5438(i);
                if (stack.method_7960()) continue;
                if (out_stack.method_7960()) {
                    if (stack.method_7947() < amount) {
                        out_stack = stack;
                        if (!simulate) {
                            this.method_5447(i, class_1799.field_8037);
                        }
                        if (!out_stack.method_7946()) break;
                        amount -= out_stack.method_7947();
                        continue;
                    }
                    if (!simulate) {
                        out_stack = stack.method_7971(amount);
                        break;
                    }
                    out_stack = stack.method_7972();
                    out_stack.method_7939(amount);
                    break;
                }
                if (!Inventories.areItemStacksIdentical(stack, out_stack)) continue;
                if (stack.method_7947() <= amount) {
                    out_stack.method_7933(stack.method_7947());
                    amount -= stack.method_7947();
                    if (simulate) continue;
                    this.method_5447(i, class_1799.field_8037);
                    continue;
                }
                out_stack.method_7933(amount);
                if (simulate) break;
                stack.method_7934(amount);
                if (!stack.method_7960()) break;
                this.method_5447(i, class_1799.field_8037);
                break;
            }
            if (!out_stack.method_7960() && !simulate) {
                this.method_5431();
            }
            return out_stack;
        }

        public class_1799 extract(class_1799 request_stack) {
            return this.extract(request_stack, false);
        }

        public class_1799 extract(class_1799 request_stack, boolean simulate) {
            class_1799 stack;
            if (request_stack.method_7960()) {
                return class_1799.field_8037;
            }
            ArrayList<class_1799> matches = new ArrayList<class_1799>();
            for (int i = 0; i < this.size_; ++i) {
                stack = this.method_5438(i);
                if (stack.method_7960() || !Inventories.areItemStacksIdenticalIgnoreDamage(stack, request_stack)) continue;
                matches.add(stack);
            }
            matches.sort(Comparator.comparingInt(class_1799::method_7947));
            if (matches.isEmpty()) {
                return class_1799.field_8037;
            }
            if (!simulate) {
                class_1799 stack2;
                int n_left = request_stack.method_7947();
                class_1799 fetched_stack = ((class_1799)matches.get(0)).method_7971(n_left);
                n_left -= fetched_stack.method_7947();
                for (int i = 1; i < matches.size() && n_left > 0; n_left -= stack2.method_7947(), ++i) {
                    stack2 = ((class_1799)matches.get(i)).method_7971(n_left);
                    fetched_stack.method_7933(stack2.method_7947());
                }
                return Inventories.checked(fetched_stack);
            }
            int amount = 0;
            for (class_1799 match : matches) {
                amount += match.method_7947();
            }
            if (amount == 0) {
                return class_1799.field_8037;
            }
            stack = request_stack.method_7972();
            if (amount < stack.method_7947()) {
                stack.method_7939(amount);
            }
            return stack;
        }

        public boolean move(int index, InventoryRange target_range, boolean all_identical_stacks, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            class_1799 source_stack = this.method_5438(index);
            if (source_stack.method_7960()) {
                return false;
            }
            if (!all_identical_stacks) {
                class_1799 remaining = target_range.insert(source_stack, only_fillup, 0, reverse, force_group_stacks);
                this.method_5447(index, remaining);
                return remaining.method_7947() != source_stack.method_7947();
            }
            class_1799 remaining = source_stack.method_7972();
            this.method_5447(index, class_1799.field_8037);
            class_1799 ref_stack = remaining.method_7972();
            ref_stack.method_7939(ref_stack.method_7914());
            for (int i = this.size_; i > 0 && !remaining.method_7960() && (remaining = target_range.insert(remaining, only_fillup, 0, reverse, force_group_stacks)).method_7960(); --i) {
                remaining = this.extract(ref_stack);
            }
            if (!remaining.method_7960()) {
                this.method_5447(index, remaining);
            }
            return remaining.method_7947() != source_stack.method_7947();
        }

        public boolean move(int index, InventoryRange target_range) {
            return this.move(index, target_range, false, false, false, true);
        }

        public boolean move(InventoryRange target_range, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            boolean changed = false;
            for (int i = 0; i < this.size_; ++i) {
                changed |= this.move(i, target_range, false, only_fillup, reverse, force_group_stacks);
            }
            return changed;
        }

        public boolean move(InventoryRange target_range, boolean only_fillup) {
            return this.move(target_range, only_fillup, false, true);
        }

        public boolean move(InventoryRange target_range) {
            return this.move(target_range, false, false, true);
        }

        public static class InventoryRangeIterator
        implements Iterator<class_1799> {
            private final InventoryRange parent_;
            private int index = 0;

            public InventoryRangeIterator(InventoryRange range) {
                this.parent_ = range;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.parent_.size_;
            }

            @Override
            public class_1799 next() {
                if (this.index >= this.parent_.size_) {
                    throw new NoSuchElementException();
                }
                return this.parent_.method_5438(this.index++);
            }
        }
    }
}

